<?php
// Include database connection
include('connection.php'); // Assuming $con is defined in this file

// Process form submission for inserting a new status
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['status'])) {
    $status = $_POST['status'];

    // Check if status is provided
    if (!empty($status)) {

        // SQL query to check if the status already exists
        $sql_check = "SELECT COUNT(*) FROM examination_result_status WHERE status = ?";
        
        if ($stmt_check = $con->prepare($sql_check)) {
            // Bind parameter for status
            $stmt_check->bind_param("s", $status);

            // Execute the statement
            $stmt_check->execute();
            $stmt_check->bind_result($count);
            $stmt_check->fetch();
            $stmt_check->close();

            if ($count > 0) {
                // If the status already exists, do not insert again
                echo "<div class='alert alert-warning'>This status is already inserted.</div>";
            } else {
                // SQL query to insert a new record (id will auto-increment)
                $sql_insert = "INSERT INTO examination_result_status (status, updated_at) VALUES (?, NOW())";
                
                if ($stmt = $con->prepare($sql_insert)) {
                    // Bind parameter: "s" for string (status)
                    $stmt->bind_param("s", $status);

                    // Execute the statement
                    if ($stmt->execute()) {
                        echo "<div class='alert alert-success'>New record inserted successfully!</div>";
                    } else {
                        echo "<div class='alert alert-danger'>Error inserting record. Please try again.</div>";
                    }

                    $stmt->close(); // Close the prepared statement
                } else {
                    echo "<div class='alert alert-danger'>Failed to prepare SQL statement.</div>";
                }
            }
        } else {
            echo "<div class='alert alert-danger'>Failed to prepare SQL statement for checking existing status.</div>";
        }
    } else {
        echo "<div class='alert alert-warning'>Please provide a valid status.</div>";
    }
}

// Process update form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_status']) && isset($_POST['id'])) {
    $status = $_POST['edit_status'];
    $id = $_POST['id'];

    if (!empty($status) && !empty($id)) {
        // SQL query to update the status
        $sql_update = "UPDATE examination_result_status SET status = ?, updated_at = NOW() WHERE id = ?";
        
        if ($stmt_update = $con->prepare($sql_update)) {
            // Bind parameters for status and id
            $stmt_update->bind_param("si", $status, $id);

            // Execute the statement
            if ($stmt_update->execute()) {
                echo "<div class='alert alert-success'>Record updated successfully!</div>";
            } else {
                echo "<div class='alert alert-danger'>Error updating record. Please try again.</div>";
            }

            $stmt_update->close(); // Close the prepared statement
        } else {
            echo "<div class='alert alert-danger'>Failed to prepare SQL statement for updating record.</div>";
        }
    } else {
        echo "<div class='alert alert-warning'>Please provide a valid status and id for the update.</div>";
    }
}

// Close the database connection
$con->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Column Status</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h2 class="mb-4 text-center">Update Column Status</h2>
        <form action="#" method="POST">
            <div class="card">
                <div class="card-header">
                    <h4>Select the status to update the column</h4>
                </div>
                <div class="card-body">
                    <div class="form-group mb-3">
                        <label for="status" class="form-label">Column Status</label>
                        <select class="form-select" id="status" name="status" required>
                            <option value="Open">Open</option>
                            <option value="Closed">Closed</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3">Update Status</button>
                </div>
            </div>
        </form>

        <!-- Display Current Status Records -->
        <div class="card mt-5">
            <div class="card-body">
                <h4 class="card-title">Current Status Records</h4>
                
                <?php
                // Include database connection
                include('connection.php'); // Assuming $con is defined in this file

                // SQL query to fetch all records from the examination_result_status table
                $sql = "SELECT id, status, updated_at FROM examination_result_status";
                $result = $con->query($sql);

                if ($result->num_rows > 0) {
                    echo '<table class="table table-bordered table-striped">';
                    echo '<thead><tr><th>ID</th><th>Status</th><th>Updated At</th><th>Action</th></tr></thead>';
                    echo '<tbody>';

                    while ($row = $result->fetch_assoc()) {
                        echo '<tr>';
                        echo '<td>' . $row['id'] . '</td>';
                        echo '<td>' . $row['status'] . '</td>';
                        echo '<td>' . $row['updated_at'] . '</td>';
                        echo '<td>';
                        // Add Edit Button
                        echo '<button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editModal" data-id="' . $row['id'] . '" data-status="' . $row['status'] . '">Edit</button>';
                        echo '</td>';
                        echo '</tr>';
                    }

                    echo '</tbody>';
                    echo '</table>';
                } else {
                    echo '<p>No records found.</p>';
                }

                // Close the database connection
                $con->close();
                ?>
            </div>
        </div>
    </div>

    <!-- Modal for Editing Status -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Edit Status</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="#">
                        <input type="hidden" id="editId" name="id">
                        <div class="form-group">
                            <label for="editStatus">Column Status</label>
                            <select class="form-select" id="editStatus" name="edit_status" required>
                                <option value="open">Open</option>
                                <option value="closed">Closed</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary mt-3">Save Changes</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<br><br><br><br>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Populate modal fields with the current row data for editing
        var editButtons = document.querySelectorAll('.btn-warning');
        editButtons.forEach(button => {
            button.addEventListener('click', function() {
                var id = this.getAttribute('data-id');
                var status = this.getAttribute('data-status');

                document.getElementById('editId').value = id;
                document.getElementById('editStatus').value = status;
            });
        });
    </script>
</body>
</html>
